// PLUGIN DATALOGGING

GIWIK.init.js(['css','msg'], 'datalogging');


// Fonctions spécifiques à l'applet DataManager (directement appelées par celui-ci) ————————————————————————————————————————————
function datamanager_connected ()
{
	window.External_Filebrowser.connected();
	window.is_logging = true;
	//alert("datamanager_connected");
};

function datamanager_disconnected ()
{
	window.External_Filebrowser.disconnected();
	window.is_logging = false;

};

function datamanager_error (code)
{
	window.External_Filebrowser.error(code);
	window.is_logging = false;
};
//——————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————


// Elaboration de la partie Date
HEADING.makeDateLogFileName = function ()
{
	var current_date	= new Date();
	var current_year	= current_date.getFullYear();
	var current_month   = current_date.getMonth() + 1; 	if (current_month   < 10) {current_month   = '0' + current_month};
	var current_day	 	= current_date.getDate(); 		if (current_day     < 10) {current_day     = '0' + current_day};
	var current_hours   = current_date.getHours(); 		if (current_hours   < 10) {current_hours   = '0' + current_hours};
	var current_minutes = current_date.getMinutes(); 	if (current_minutes < 10) {current_minutes = '0' + current_minutes};
	var current_seconds = current_date.getSeconds(); 	if (current_seconds < 10) {current_seconds = '0' + current_seconds};

	return ''+current_year+''+current_month+''+current_day+'-'+current_hours+''+current_minutes+''+current_seconds;
};

// Elaboration du nom de fichier de logging externe
HEADING.makeExternalLogFilename = function (port)
{
	// Si le choix du port n'est pas proposé sur l'IHM
	if (!GIWIK._plugins.datalogging._ports)
	{
		var log_port = '';
	}
	else
	{
		var log_port = (port == 'Repeater' || !port) ? '-R' : '-'+GIWIK._plugins.datalogging._ports[port].replace(/[^\s]+\s+([A-Z])$/,'$1');
	}

	var current_date	= new Date();
	var current_year	= current_date.getFullYear();
	var current_month   = current_date.getMonth() + 1; 	if (current_month < 10)   {current_month   = '0' + current_month};
	var current_day	 	= current_date.getDate(); 		if (current_day < 10)	  {current_day     = '0' + current_day};
	var current_hours   = current_date.getHours(); 		if (current_hours < 10)   {current_hours   = '0' + current_hours};
	var current_minutes = current_date.getMinutes(); 	if (current_minutes < 10) {current_minutes = '0' + current_minutes};
	var current_seconds = current_date.getSeconds(); 	if (current_seconds < 10) {current_seconds = '0' + current_seconds};

	return GIWIK.system_name+log_port+'-'+HEADING.makeDateLogFileName()+'.log';
};

if (HEADING.name == 'datalogging')
{
	HEADING.openDataLogger = function ()
	{
		// Si l'objet Filebrowser est initialisé (on a besoin de Filebrowser.save_dir)
		if (window.External_Filebrowser.init == false)
		{
			var name = escape(window.External_FileName.getValue());
			var path = escape(window.External_Filebrowser.save_dir);
			var port = window.Select_port.getValue();


			var tlimit = 0;
			var slimit = 0;
			var decim  = 1;

			// Recuperation Infos Segmentation
			tlimit = (window.Select_option.selected_option == 1) ? window.Input_option.getValue() : 0;
			slimit = (window.Select_option.selected_option == 2) ? window.Input_option.getValue() : 0;
			decim = window.Select_Rate._value[window.Select_Rate.selected_option];

			// Nom de la fenêtre
			var window_name = GIWIK.makeDataloggerWindowName(port);

			// Un datalogger possible par port
			GIWIK.window.open("../datalogger/?mode=autolog&name="+name+"&path="+path+"&slimit="+slimit+"&tlimit="+tlimit+"&decim="+decim+"&port="+port+"&protocol="+"", window_name, 500, 352, 10, (screen.width-(480+20)), "toolbar=0, menubar=0, status=0, resizable=0, scrollbars=1");


			// On change de nom de fichier après chaque ouverture du data logger
			window.External_FileName.setValue(HEADING.makeExternalLogFilename(window.Select_port.getValue()));
		}
		else
		{
			setTimeout("HEADING.openDataLogger()", 20);
		}
	};

	// Construction du contenu de la rubrique
	HEADING.construct._plugins.datalogging = function ()
	{
		if(GIWIK.external_datalogging)
		{		
			var cnt = ''

			// External Log Box
			// ----------------------
			//cnt += '<div id="usermsg_logging"></div>'

			+'<div id="external_savedir_info" >'
				+ '<table id="external_savedir_ctnr" class="savedir_ctnr_class">'
					+'<tr>'
						+'<td>'
							+'<div>'
								+'<div id="external_filename"></div>'
								+'<div id="box_external_savedir_label" class="box_savedir_label_class"></div>'
								+'<div id="external_savedir" class="savedir_class"></div>'
							+'</div>'
						+'</td>'
						+'<td id="startstop_ctnr" >'
							+'<div id="start_logging" class="displaynone"></div>'
						+'</td>'
					+'</tr>'
				+'</table>'
			+ '</div>'

			+'<div id="external_output_selection">'
				+ '<table class="output_selection_class" >'
					+'<tr>'
						+'<td>'
							+'<div id="select_port"></div>'
							+'<div id="rate_option"></div>'
							+'<table><tr>'
								+'<td><div id="select_option"></div></td>'
								+'<td><div id="optionvalue"></div></td>'
							+'</tr></table>'
						+'</td>'
					+'</tr>'
				+'</table>'
			+'</div>'


			/*cnt += '<table id="external_logging_ctnr">'
				+'<tr>'
					+'<td>'
						+'<div id="select_port"></div>'
						+'<div id="external_file_name"></div>'

						+'<table><tr>'
							+'<td><div id="select_option"></div></td>'
							+'<td><div id="optionvalue"></div></td>'
						+'</tr></table>'

						+'<div id="external_savedir_ctnr" class="savedir_ctnr_class" >'
							+'<div id="box_external_savedir_label" class="box_savedir_label_class"></div>'
							+'<div id="external_savedir" class="savedir_class"></div>'
						+'</div>'
					+'</td>'
					+'<td id="startstop_ctnr">'
						+'<div id="stop_logging" class="displaynone"></div>'
						+'<div id="start_logging" class="displaynone"></div>'
					+'</td>'
				+'</tr>'
			+'</table>'*/

			+'<div id="external_filebrowser" class="filebrowser_class">'
				+'<div id="external_filebrowser_content" class="filebrowser_content_class"></div>'
			+'</div>'

			+'<div id="java_applet_ctnr"><applet name="DataManager" archive="'+GIWIK.directories.applets+'/DataManager.jar" code="org/ixsea/datamanager/DataManager.class" width="1" height="1" mayscript=""></applet></div>';

			// Construction de la boite
			$('#content').append(GIWIK.box(cnt, MSG(['box','datalogging_title']), false, ['box_datalogging'], ['','box_content_nopaddingtop']));


			// External Logging Objets
			// -------------------------------

			// Construction des groupes de parametres
			GIWIK.paramGroup.construct('external_savedir_info', MSG(['box','savedir_infos']), 'show');
			GIWIK.paramGroup.construct('external_output_selection', MSG(['box','external_log_outputselect']), 'show');
			GIWIK.paramGroup.construct('external_filebrowser', MSG(['box','savedir_filebrowser']), 'hide');


			// Instanciation de l'objet File_browser gérant l'explorateur de fichier
			window.External_Filebrowser = new File_browser('External_Filebrowser');
			window.External_Filebrowser.setSaveDirField('external_savedir');
			window.External_Filebrowser.setFileBrowseContentField('external_filebrowser_content');
			window.External_Filebrowser.setOperatingMode('applet');
			window.External_Filebrowser.setLogInProgress(0);
			window.External_Filebrowser.construct();

			// Lien sur repertoire courant vers filebrowser
			$('#box_external_savedir_label').attr('title', MSG(['box','open_filebrowser_title']));
			GIWIK.setClick('box_external_savedir_label', "GIWIK.paramGroup.display('external_filebrowser', 'show');");

			GIWIK.write('box_external_savedir_label',MSG(['box','savedir_label']));
			GIWIK.css.setClass('external_savedir', 'floatleft');


			// Selection Port
			var _output_ports_plus_repeater        = (GIWIK._plugins.datalogging.repeater_port === false) ? [] : ['Repeater'];
			var _output_ports_labels_plus_repeater = (GIWIK._plugins.datalogging.repeater_port === false) ? [] : ['Repeater'];

			if (GIWIK._plugins.datalogging._ports)
			{
				_output_ports_plus_repeater        = _output_ports_plus_repeater.concat(array_keys(GIWIK._plugins.datalogging._ports));
				_output_ports_labels_plus_repeater = _output_ports_labels_plus_repeater.concat(array_values(GIWIK._plugins.datalogging._ports));
			}

			window.Select_port = new Input_select('Select_port', false);
			window.Select_port.label_width =  82 ;
			window.Select_port.margin = '0px 0 0 0';
			window.Select_port.construct('select_port','linear',MSG(['parameters','datalogging_outputport_label']),_output_ports_plus_repeater,_output_ports_labels_plus_repeater,'');
			window.Select_port.setAction("window.External_FileName.setValue(HEADING.makeExternalLogFilename(window.Select_port.getValue()));if (window.Select_port.value==='Repeater') { window.Select_Rate.show(); } else { window.Select_Rate.hide();}", true);
			window.Select_port.setValue(window.Select_port._value[(GIWIK._plugins.datalogging.repeater_port !== false && _output_ports_plus_repeater.length > 1) ? 1 : 0]);
			window.Select_port.enable();
			window.Select_port[(GIWIK._plugins.datalogging._ports) ? 'show' : 'hide']();

			// File Name Input
			window.External_FileName = new Input_text('External_FileName', false);
			window.External_FileName.label_width = 82;
			window.External_FileName.input_width = 215;
			window.External_FileName.margin = '0px 15px 20px 0';
			window.External_FileName.text_align = 'left';
			window.External_FileName.construct('external_filename','linear',MSG(['parameters','datalogging_filename']),'',false);
			window.External_FileName.input_path.style.fontWeight = 'normal';
			window.External_FileName.enable();
			window.External_FileName.show();
			window.External_FileName.setValue(HEADING.makeExternalLogFilename(window.Select_port.getValue()));

			// Rate Option
			window.Select_Rate = new Input_select('Select_Rate', false);
			window.Select_Rate.margin = '12px 40px 0 0';
			window.Select_Rate.label_width = 82;
			window.Select_Rate.construct('rate_option','linear',MSG(['parameters','datalogging_rate_option_label']),MSG(['lists','datalogger','rate_values']),MSG(['lists','datalogger','rate_options']),"");
			window.Select_Rate.setValue(1);
			window.Select_Rate.enable();
			window.Select_Rate.hide();

			// External Log Option
			window.Select_option = new Input_select('Select_option', false);
			window.Select_option.margin = '12px 40px 0 0';
			window.Select_option.label_width = 82;
			window.Select_option.construct('select_option','linear',MSG(['parameters','datalogging_option_label']),array_keys(MSG(['lists','datalogger','options_unit'])),MSG(['lists','datalogger','options_unit']),'');
			window.Select_option.setAction('if (this.selected_option){window.Input_option.show();} else{window.Input_option.hide(\'displaynone\');}', true);
			window.Select_option.setValue(0);
			window.Select_option.enable();
			window.Select_option.show();

			window.Input_option = new Input_int('Input_option', false);
			window.Input_option.input_width = 82;
			window.Input_option.construct('optionvalue','linear','',1/*step*/,0/*min*/,1000000/*max*/,'', 1/*jump*/);
			window.Input_option.setValue(0);
			window.Input_option.enable();
			window.Input_option.hide();

			// Start Logging Button
			window.Start_logging = new Button('Start_logging', false);
			window.Start_logging.margin = '0px 0px 0px 0px';
			window.Start_logging.construct('start_logging',MSG(['buttons','start_logging']));
			window.Start_logging.setAction("window.settings_modified=false;HEADING.openDataLogger();");
			window.Start_logging.enable();
			window.Start_logging.show();
		}
	};
}


else if (HEADING.name == 'datalogger')
{
	HEADING.is_external_popup = true;

	HEADING.startLogging = function ()
	{
		// Si l'applet est initialisé
		if (window.External_Filebrowser.init == false)
		{
			// Affichage du message d'attente de connexion
			window.External_Filebrowser.set_statusmsg(3);

			// Timer afin de recuperer infos Applet
			GIWIK.setTimer("HEADING.updateLoggingData();", 2000, "window.datalogger_timer"+window._GET['port']);

			if (typeof window._GET['path'] != 'string')
			{
					HEADING.logging_name = HEADING.makeExternalLogFilename();
					HEADING.logging_path = trim(unescape(window.External_Filebrowser.save_dir).replace(/([^\/])$/gi,'$1/'));

					GIWIK.write('datalogger_filename',HEADING.logging_name);
					GIWIK.write('datalogger_path',HEADING.logging_path);
			}

			/*alert("setMode("+HEADING.logging_mode+");\n"
						+"setProtocole("+HEADING.logging_proto+");\n"		// protocole
						+"setTimeMax(60*"+HEADING.logging_time+");\n"		// secondes
						+"setSizeMax("+HEADING.logging_size+");\n"			// koctets
						+"setSerialNum("+GIWIK.product_serial_number+");\n"   // serial num
						+"setProductName("+GIWIK.system_name+");\n"		// product name
						+"setDecimation("+HEADING.decimation+");\n"			// rate
						+"startLogging("+window.ip+","+HEADING.logging_ip_port+","+HEADING.logging_path+HEADING.logging_name+");\n");*/

			with(document.applets[0])
			{
				setMode(HEADING.logging_mode);
				setProtocole(HEADING.logging_proto);		// protocole
				setTimeMax(60*HEADING.logging_time);		// secondes
				setSizeMax(HEADING.logging_size);			// koctets
				setSerialNum(GIWIK.product_serial_number);	// serial num
				setProductName(GIWIK.system_name);			// product name
				setIPLog(HEADING.logging_ip_log);
				setDecimation(HEADING.decimation);
				startLogging(window.ip,HEADING.logging_ip_port,HEADING.logging_path+HEADING.logging_name);
			}
		}
		else
		{
			setTimeout("HEADING.startLogging();", 20);
		}
	};

	HEADING.stopLogging = function ()
	{
		// Arret Timer
		clearInterval(eval("window.datalogger_timer"+window._GET['port']));

		window.Stop_logging.disable();
		document.applets[0].stopLogging();
	};

	HEADING.updateLoggingData = function ()
	{
		var totallogsize = 0;
		var totallogtime = 0;
		var h,m,s;
		var logsizetxt = "";
		var logtimetxt = "";
		var filelogname = "";


		// Recuperation Taille Courante Log
		with(document.applets[0])
		{
			totallogsize = getTotalLogSize();
			totallogtime = getTotalLogTime();
			filelogname	 = getFileName().replace(/^.*(?:\/|\\)(.+)$/, "$1"); // Récupération du nom de fichier à partir de son chemin complet
		}

		// Affichage Info: Si enregistrement en cours ..
		if (window.is_logging)
		{
			if(GIWIK.connection_lost)
			{
				//Effacement des informations de temps et de taille de fichier
				GIWIK.write('logging_info_msg', '');
				if(GIWIK.connection_lost)
				{
					//Levée de l'erreur de connexion
					datamanager_error(2304);
				}
			}
			else
			{
				// Formatage Taille:
				// <1Mo: 1ko à 999ko
				if (totallogsize <= 999)
				{
					// xxxko
					logsizetxt = parseInt(totallogsize) +"ko";
				}
				// <1Go: 1.000Mo à 999.999Mo
				else if (totallogsize <= 999999)
				{
					// affichage Mo
					logsizetxt = parseInt(totallogsize/1000)+",";

					// affiage ko
					totallogsize = totallogsize%1000;

					if (parseInt(totallogsize) >= 100)
					{
						logsizetxt += parseInt(totallogsize)+"Mo";
					}
					else if (parseInt(totallogsize) >= 10)
					{
						logsizetxt += "0"+parseInt(totallogsize)+"Mo";
					}
					else if (parseInt(totallogsize) >= 1)
					{
						logsizetxt += "00"+parseInt(totallogsize)+"Mo";
					}
					else
					{
						logsizetxt += "000"+"Mo";
					}
				}
				// > 1Go: xx.xxxGo
				else
				{
					// affichage Go
					logsizetxt = parseInt(totallogsize/1000000)+",";

					// affichage Mo
					totallogsize = ((totallogsize%1000000)/1000);

					if (parseInt(totallogsize) >= 100)
					{
						logsizetxt += parseInt(totallogsize)+"Go";
					}
					else if (parseInt(totallogsize) >= 10)
					{
						logsizetxt += "0"+parseInt(totallogsize)+"Go";
					}
					else if (parseInt(totallogsize) >= 1)
					{
						logsizetxt += "00"+parseInt(totallogsize)+"Go";
					}
					else
					{
						logsizetxt += "000"+"Go";
					}
				}

				// Formatage heure
				// type: 05h37m12s
				h = (totallogtime/3600);
				m = (totallogtime%3600)/60;
				s = (totallogtime%60);

				if (h <= 9)
				{
					logtimetxt += "0"+parseInt(h)+"h";
				}
				else
				{
					logtimetxt += parseInt(h)+"h";
				}

				if (m == 0)
				{
					logtimetxt += "00"+"m";
				}
				else if (m <= 9)
				{
					logtimetxt += "0"+parseInt(m)+"m";
				}
				else
				{
					logtimetxt += parseInt(m)+"m";
				}

				if (s == 0)
				{
					logtimetxt += "00"+"s";
				}
				else if (s <= 9)
				{
					logtimetxt += "0"+parseInt(s)+"s";
				}
				else
				{
					logtimetxt += parseInt(s)+"s";
				}

				// Mise à jour infos Taille courante et Temps courant enregistrement
				GIWIK.write('logging_info_msg', MSG(['lists','datalogger','options_unit'])[1]+": "+logtimetxt+" - "+MSG(['lists','datalogger','options_unit'])[2]+": "+logsizetxt);

				// Mise à jour du nom du fichier
				HEADING.logging_name = filelogname;
				GIWIK.write('datalogger_filename', HEADING.logging_name);
			}
		}
		else
		{
			//Do nothing
		}
	};

	HEADING.getConf._plugins.datalogging = function ()
	{
		// Lors de l'init, on récupère le contenu des listes
		if (!HEADING.init.isdone)
		{
			var _params = {};

			_params['SerialNumber'] = "";

			if (in_array(window._GET['port'], array_keys(GIWIK._plugins.datalogging._ports)))
			{
				var eth_param_name = (typeof HEADING.getEthConfParamName == 'function')
								   ? HEADING.getEthConfParamName(window._GET['port'])
								   : HEADING.ethconf_param_name+window._GET['port'];

				_params[eth_param_name] = "";
			}

			return _params;
		}
	};

	HEADING.readConf._plugins.datalogging = function ()
	{
		GIWIK.product_serial_number = window[system].SerialNumber;

		if (!HEADING.init.isdone)
		{
			// Récupération et traitement des paramètres à passer à l'applet
			HEADING.logging_name = (window._GET['name'])   ? trim(unescape(window._GET['name']).replace(/[^ a-z0-9_\-\.àâäéèëîïöôùüû]/gi,'-')) : '';
			HEADING.logging_path = (window._GET['path'])   ? trim(unescape(window._GET['path']).replace(/([^\/])$/gi,'$1/')) : '';
			HEADING.logging_time = (window._GET['tlimit']) ? trim(unescape(window._GET['tlimit'])) : 0;
			HEADING.logging_size = (window._GET['slimit']) ? trim(unescape(window._GET['slimit'])) : 0;
			HEADING.decimation   = (window._GET['decim'])  ? trim(unescape(window._GET['decim'])) : 1;


			// Récupération du port ip
			if (in_array(window._GET['port'], array_keys(GIWIK._plugins.datalogging._ports)))
			{
				var eth_param_name = (typeof HEADING.getEthConfParamName == 'function')
								   ? HEADING.getEthConfParamName(window._GET['port'])
								   : HEADING.ethconf_param_name+window._GET['port'];

				HEADING.logging_ip_port = eval("window[system]."+eth_param_name+"["+HEADING.ethconf_ipport_index+"]");
				HEADING.logging_ip_log  = eval("window[system]."+eth_param_name+"["+2+"]");
				HEADING.logging_proto   = eval("window[system]."+eth_param_name+"["+HEADING.ethconf_elcfox_index+"]");
				HEADING.logging_mode    = 2;
			}
			// Par défaut, port repeater
			else
			{
				HEADING.logging_ip_port = GIWIK._plugins.network.repeater_port;
				HEADING.logging_proto   = 0; // TCP client
				HEADING.logging_ip_log  = window.ip;

				// Définition du mode d'enregistrement en fonction du produit
				// Définition du mode d'enregistrement en fonction du produi

                switch (GIWIK.ihm_codename)
                {
					case 'gyro': HEADING.logging_mode = 0;                               break;
					case 'ins' : HEADING.logging_mode = (GIWIK.is_gyro == true) ? 0 : 1; break;
					default    : HEADING.logging_mode = 2;                               break;

                }
			}

			GIWIK.write('datalogger_port',(window._GET['port'] && window._GET['port'] != 'Repeater') ? GIWIK._plugins.datalogging._ports[window._GET['port']] : 'Repeater');
			GIWIK.write('datalogger_filename',HEADING.logging_name);
			GIWIK.write('datalogger_path',HEADING.logging_path);

			// Info segmentation utilisée
			if (HEADING.logging_time != 0)
			{
				GIWIK.write('datalogger_option',MSG(['lists','datalogger','options_unit'])[1]+":  "+HEADING.logging_time+"min");
			}
			else if (HEADING.logging_size != 0)
			{
				GIWIK.write('datalogger_option',MSG(['lists','datalogger','options_unit'])[2]+":  "+HEADING.logging_size+"ko");
			}
			else
			{
				GIWIK.write('datalogger_option',MSG(['lists','datalogger','options_unit'])[0]);
			}

			// Gestion de l'alias
			if (GIWIK._plugins.network.alias)
			{
				// Ajout de l'alias dans le titre de la boite
				GIWIK.write('box_datalogger_title', '<span class="alias"> - '+window[system].Alias+'</span>', 'append');
			}

			// Si un démarrage auto de l'enregistrement est demandé
			if (window._GET['mode'] && window._GET['mode'] == 'autolog')
			{
				HEADING.startLogging();
			}
		}
	};

	HEADING.construct._plugins.datalogging = function ()
	{
		window.is_logging = false;

		// Nom du paramètre de configuration ethernet en sortie ("EthConf" par défaut)
		HEADING.ethconf_param_name =   (GIWIK._plugins.network._ethconf && typeof GIWIK._plugins.network._ethconf.param_name   == 'string') ? GIWIK._plugins.network._ethconf.param_name : "EthConf";
		HEADING.ethconf_elcfox_index = (GIWIK._plugins.network._ethconf && typeof GIWIK._plugins.network._ethconf.elcfox_index == 'number') ? GIWIK._plugins.network._ethconf.elcfox_index : 1;
		HEADING.ethconf_ipport_index = (GIWIK._plugins.network._ethconf && typeof GIWIK._plugins.network._ethconf.ipport_index == 'number') ? GIWIK._plugins.network._ethconf.ipport_index : 3;

		var cnt = ''

		 +'<div id="usermsg_logging"></div>'

		// TEMPORAIRE (à intégrer à l'objet message "usermsg_logging"
		+'<div id="logging_info_msg" style="position:absolute;margin:-15px 0 0 100px;text-align:center;color:'+GIWIK.css.color_1+';"></div>\n'

			+'<table class="labels_values"><tr>\n'
				+'<td class="labels state_1">\n'
					+'<div id="datalogger_port_label"></div>\n'
					//+'<div id="datalogger_protocol_label"></div>\n'
					+'<div id="datalogger_filename_label"></div>\n'
					+'<div id="datalogger_path_label"></div>\n'
					+'<div id="datalogger_option_label"></div>\n'
				+'</td>\n'
				+'<td class="values">\n'
						+'<div id="datalogger_port"></div>\n'
						//+'<div id="datalogger_protocol"></div>\n'
						+'<div id="datalogger_filename"></div>\n'
						+'<div id="datalogger_path"></div>\n'
						+'<div id="datalogger_option"></div>\n'
				+'</td>\n'
				+'<td id="stop_logging_ctnr">\n'
					+'<div id="stop_logging"></div>\n'
				+'</td>\n'
			+'</tr></table>\n'

		+'<div id="java_applet_ctnr"><applet name="DataManager" archive="'+GIWIK.directories.applets+'/DataManager.jar" code="org/ixsea/datamanager/DataManager.class" width="1" height="1" mayscript=""></applet></div>\n';

		// Construction de la boite
		$('#content').append(GIWIK.box(cnt, MSG(['box','datalogger_title']), false, ['box_datalogger'], ['','box_content_nopadding']));

		cnt = null;


		GIWIK.write('datalogger_port_label', MSG(['box','datalogger_port_label']));
		//GIWIK.write('datalogger_protocol_label', MSG(['box','datalogger_protocol_label']));
		GIWIK.write('datalogger_filename_label', MSG(['box','datalogger_filename_label']));
		GIWIK.write('datalogger_path_label', MSG(['box','datalogger_path_label']));
		GIWIK.write('datalogger_option_label', MSG(['box','datalogger_option_label']));

		// Si on n'a pas le choix de la sortie à logger
		if (!GIWIK._plugins.datalogging._ports)
		{
			GIWIK.css.setClass('datalogger_port_label', 'displaynone');
			GIWIK.css.setClass('datalogger_port', 'displaynone');
		}

		// Construction du message de logging
		window.Usermsg_logging = new User_msg('Usermsg_logging', false);
		window.Usermsg_logging.margin = '8px 0 8px 0';
		window.Usermsg_logging.construct('usermsg_logging');
		window.Usermsg_logging.setStatus(1, false);
		window.Usermsg_logging.show();


		// Instanciation de l'objet File_browser gérant l'explorateur de fichier
		window.External_Filebrowser = new File_browser('External_Filebrowser');
		window.External_Filebrowser.setOperatingMode('applet');
		window.External_Filebrowser.construct('hidden');

		window.Stop_logging = new Button('Stop_logging', false);
		window.Stop_logging.construct('stop_logging',MSG(['buttons','stop_logging']));
		window.Stop_logging.setAction('HEADING.stopLogging();');
		window.Stop_logging.disable();
		window.Stop_logging.show();
	};
}




// Classe File_browser:
// --------------------------
window.File_browser = function (self)
{
	this.self = self;

	this.init = true;	 // marque l'état d'initialisation de l'objet

	this._listdir;			// tableau des enfants du dossier courant
	this.current_dir;		// dossier courant
	this.parent_dir;		// dossier parent
	this.save_dir;			// dossier sélectionné pour le l'enregistrement
	this.base_directory;	// dossier de bas pour le log (internal log :: CGI)

	this.os;				// OS (UNIX ou Windows)

	this.log_inprogress;	// log in progress
	this.mode;

	this.current_createfolder_input;
	this.createfolder_done;

	this.alertdebug;

	// Défini le champ d'affichage du répertoire sélectionné
	this.setSaveDirField = function (savedirfield)
	{
		this.savedirfield = savedirfield;
	}

	// Défini la division contenant l'objet (affichage repertoires)
	this.setFileBrowseContentField = function (filebrowser_content)
	{
		this.filebrowser_content = filebrowser_content;
	}

	// Défini l'état du log: en cours ou non
	this.setLogInProgress = function (loginprogress)
	{
		// Store Log State
		this.log_inprogress = loginprogress;

		// Update FileBrowser
		this.updatefilebrowser();
	}

	// Défini le mode de fonctionnement du File brower:
	// - via Applet java (log sur PC)
	// - via CGI (log interne)
	this.setOperatingMode = function (operating_mode)
	{
		this.operating_mode = operating_mode;
	}

	// hidden_mode = true permet de lancer l'objet de façon transparente (sans explorateur de fichier)
	this.construct = function (mode)
	{
		//  Applet Mode
		if (this.operating_mode == 'applet')
		{
			// !!! NE PAS TOUCHER !!! : seule et unique technique permettant de s'assurer que l'applet et toutes ses méthodes sont bien chargées
			var test_init = '';
			try{test_init = document.applets[0].test_init();}
			catch(e){test_init ='nok';}
			// !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

			// Si l'applet n'est pas prêt, on retente plus tard
			if (test_init != 'ok')
			{
				setTimeout(this.self+".construct('"+mode+"')", 100);
				return;
			}
		}

		this.mode = (mode == 'hidden') ? 'hidden' : 'visible';

		//---------------------------------------------------------------------------------------
		// Sur quel OS l'IHM tourne-t-elle ?
		//---------------------------------------------------------------------------------------
		if (this.operating_mode == 'applet')
		{
			var tmp = document.applets[0].listDir();
		}
		else
		{
			var tmp = "/";
		}

		// Création d'une 2ème variable pour avoir un type String correct (problèmes avec les types string de Java)
		var tmp2 = "";
		tmp2 += tmp;

		var _tmp = new Array();

		_tmp = tmp2.split(",");


		if (_tmp.length > 0)
		{
			if (_tmp[0] == "/")
			{
				this.os = "unix";
			}
			else
			{
				this.os = "windows";
			}
			//alert(this.os);
		}

		//---------------------------------------------------------------------------------------
		// Définition du dossier de sauvegarde
		//---------------------------------------------------------------------------------------
		// Récupérarion dans le cookie permanent du dossier de sauvegarde courant
		if (STORAGE.get(this.self+'_savedir'))
		{
			this.save_dir = STORAGE.get(this.self+'_savedir');
		}
		// par défault c:/ est choisi pour windows et "/" pour Unix
		else
		{
			switch (this.os)
			{
				case 'windows':
					this.save_dir = "C:/";
					break;

				case 'unix':
					this.save_dir = "/";
					break;
			}
		}

		// Cas de l'explorateur caché, l'initialisation est terminée simplement quand l'applet est lui-même initialisé et que this.save_dir est définit
		if (this.mode == 'hidden')
		{
			this.init = false;
		}
		else
		{
			//---------------------------------------------------------------------------------------
			// Définition du dossier courant (le niveau parent du dossier de sauvegarde)
			//---------------------------------------------------------------------------------------
			/*this.save_dir = '/bob/test';
			this.os = 'unix';*/

			var _tabdir = this.save_dir.split('/');


			// Si c'est un dossier racine qui est sélectionné, on affiche le poste de travail
			if (_tabdir.length == 2 && ((this.os == 'unix' && _tabdir[0] == "") || (this.os == 'windows' && _tabdir[1] == "")))
			{
				this.current_dir = '/';
			}
			else
			{
				switch (this.os)
				{
					case 'windows':
						this.current_dir = "";
						break;

					case 'unix':
						this.current_dir = "/";
						break;
				}

				//alert(_tabdir);

				for (i=0; i<_tabdir.length-1; i++)
				{
					this.current_dir += _tabdir[i];

					// Ajout d'un antislash entre chaque niveau (pas au début ni à la fin) OU à la fin quand le parent est la racine d'un lecteur
					if (_tabdir[i] != '' && (i<_tabdir.length-2 || _tabdir.length == 2))
					{
						this.current_dir += '/';
					}
				}
			}

			// Get Directory List
			this.getdirlist();
		}
	};

	// Lecture Liste des sous-repertores
	// ------------------------------------------
	this.getdirlist = function (dir)
	{
		// Par défaut le dossier cible est le dossier courant
		if (typeof dir == 'undefined')
		{
			var dir = this.current_dir;
		}

		// Mode Applet
		if (this.operating_mode == 'applet')
		{
			// Demande à l'applet Java de la liste des répertoires du dossier en cours
			var java_listdir = document.applets[0].listDir(dir);

			// Analyse de le reponse
			this.analyse_getdirlist(java_listdir);
		}

		// Mode CGI
		else
		{
			// Demande au CGI la liste des répertoires du dossier en cours
			var request = GIWIK.cgifile+"?mode=3";

			// Folder list
			request += "&listdir="+dir;

			// File list
			request += "&listfile="+dir;

			// File Size List
			request += "&listfilesize="+dir;

			// Base directory
			request += "&basedir";

			// Request avec traitement specifique de la reponse
			GIWIK.ajax(request, {eval_rtxt:true, replace_standard_callback:'window.'+this.self+'.analyse_getdirlist();'});

			/*request = window.cgifile+"?mode=9&listfile"+dir;
			GIWIK.ajax_NG(request, 0);
			request = null;*/
		}
	};


	// Analyse de la reponse lors demande Liste Repertoires
	// -------------------------------------------------------------------
	this.analyse_getdirlist = function (_listdir)
	{
		var listdir      = "",
			listfile     = "",
			listfilesize = "",
			basedir      = "";

		// Stockage du résultat dans une variable de type "string"
		if (this.operating_mode == 'applet')
		{
			listdir += _listdir;
		}
		else
		{
			listdir      += window[system].listdir;
			listfile     += window[system].listfile;
			listfilesize += window[system].listfilesize;
			basedir      += window[system].basedir;
		}

		//this.alertdebug = 'current dir :\n' + this.current_dir + '\n\nsave dir :\n' + this.save_dir + '\n\nApplet/CGI dit :\n' + listdir;
		//alert(this.alertdebug);

		// Récupération dossier racine
		if (this.operating_mode == 'cgi')
		{
			this.base_directory = basedir;
		}

		// Suppression des éventuels guillemets doubles
		listdir  = listdir.replace(/"/g,"");
		listfile = listfile.replace(/"/g,"");

		// Vidage du tableau des dossiers avant son remplissage
		this._listdir      = [];
		this._listfile     = [];
		this._listfilesize = [];

		// Si la réponse  est pas vide
		if (listdir != '')
		{
			this._listdir = (listdir.split('*')).sort();
		}

		if (listfile != '')
		{
			this._listfile     = (listfile.split('*'));
			this._listfilesize = (listfilesize.split('*'));
		}

		// Traitement Spécifique Applet
		if (this.operating_mode == 'applet')
		{
			// Cas de la poubelle window à ne pas afficher
			if (this.os == 'windows' && in_array('$RECYCLE.BIN', this._listdir))
			{
				var _listdir_tmp = new Array();

				for (var dir_index in this._listdir)
				{
					if (this._listdir[dir_index] != '$RECYCLE.BIN')
					{
						_listdir_tmp.push(this._listdir[dir_index]);
					}
				}

				this._listdir = _listdir_tmp;

				_listdir_tmp = null;
			}
		}

		//------------------------------------------------------------------------------------
		// Définition du dossier parent
		//------------------------------------------------------------------------------------

		// Split de l'adresse du dossier courant
		var _splitcurrentdir = this.current_dir.split('/');

		//alert(this.current_dir+" _splicurrentdir : "+_splitcurrentdir);

		// Si le dossier courant est le poste de travail
		if (this.current_dir == '/')
		{
			this.parent_dir = null;
		}
		// Si le dossier courant est la racine d'un lecteur
		else if (_splitcurrentdir.length == 2 && ((this.os == 'unix' && _splitcurrentdir[0] == '') || (this.os == 'windows' && _splitcurrentdir[1] == '')))
		{
			this.parent_dir = '/';
		}
		// Pour n'importe quel autre dossier
		else
		{
			// Pour Unix, la racine globale est marquée par un slash
			switch (this.os)
			{
				case 'windows':
					this.parent_dir = '';
					break;
				case 'unix':
					this.parent_dir = '/';
					break;
			}

			for (var i=0; i<_splitcurrentdir.length-1; i++)
			{
				this.parent_dir += _splitcurrentdir[i];

				// Ajout d'un antislash entre chaque niveau (pas au début ni à la fin) OU à la fin quand le parent est la racine d'un lecteur
				if (_splitcurrentdir[i] != '' && (i < _splitcurrentdir.length-2 || _splitcurrentdir.length == 2))
				{
					this.parent_dir += '/';
				}
			}
			//alert(this.parent_dir);
		}
		_splitcurrentdir = null;

		//------------------------------------------------------------------------------------
		// Construction de l'adresse complète de chaque dossier/fichier
		//------------------------------------------------------------------------------------
		var dir_tmp = '';

		// Dossiers
		for (var i=0; i<this._listdir.length; i++)
		{
			// S'il ne s'agit pas du poste de travail
			if (this._listdir[i] != '')
			{
				// Concaténation du dossier courant avec le dossier de la liste (un slash est ajouté entre les 2 si besoin)
				dir_tmp = this.current_dir.replace(/([^\/]{1})$/gi,'$1/') + this._listdir[i];

				// Pour Windows, on supprime le slash du début
				if (this.os == 'windows')
				{
					dir_tmp = dir_tmp.replace(/^\//gi,'');
				}

				this._listdir[i] = dir_tmp;
			}
		}
		dir_tmp = null;

		// Fichiers
		for (var i=0; i<this._listfile.length; i++)
		{
			// S'il ne s'agit pas du poste de travail
			if (this._listfile[i] != '')
			{
				// Concaténation du dossier courant avec le dossier de la liste (un slash est ajouté entre les 2 si besoin)
				this._listfile[i] = this.current_dir.replace(/([^\/]{1})$/gi,'$1/') + this._listfile[i];
			}
		}

		// Ajout du dossier parent en première position du tableau des dossiers SI le dossier en cours n'est pas le poste de travail
		if (this.current_dir != '/')
		{
			this._listdir.unshift(this.parent_dir);
		}

		//this.alertdebug += '\n\ntableau final :\n'+this._listdir.join('\n');

		// S'il s'agit de la fin de l'initialisation
		if (this.init)
		{
			this.init = false;
		}

		this.updatefilebrowser();
	};

	// Set save  folder
	// ---------------------
	this.setsavedir = function (dir)
	{
		this.save_dir = dir;
		STORAGE.setPermanent(this.self+'_savedir', dir);
		this.updatefilebrowser();
	};

	// Get Current directory
	this.getsavedir = function ()
	{
		return this.save_dir;
	};

	// Go to dir
	// ------------
	this.gotodir = function (dir)
	{
		// vidage du tableau des dossiers avant son remplissage
		//this._listdir = new Array();

		this.current_dir = dir;

		//GIWIK.write(this.currentdirfield, 'current dir : '+this.current_dir);

		// Get sub directories
		this.getdirlist(this.current_dir);
	};

	// Update File Browser
	// ---------------------------
	this.updatefilebrowser = function ()
	{
		if (this.mode == 'visible')
		{
			if (typeof this._listdir == 'object')
			{
				var filebrowser  = "",
					dir          = "",
					dir_escaped  = "",
					file         = "",
					file_escaped = "",
					filesize     = "";

				// Liste Repertoires
				// ----------------------
				for (i=0; i<this._listdir.length; i++)
				{
					dir = this._listdir[i];

					// Echappement des antislashes et des guillemets simples
					dir_escaped = dir.replace(/\\/g,"\\\\");
					dir_escaped = dir_escaped.replace(/'/g,"\\'");

					// Cas particulier du répertoire racine: Log interne
					if (dir_escaped == '/.')
					{
						dir_escaped = '/';
					}

					var cssdir = "";
					var cssdir_onmouseover = "";
					var cssdir_onmouseout = "";

					// S'il s'agit du dossier sélectionné
					if (dir_escaped == this.save_dir && ((this.current_dir != '/' && i != 0) || this.current_dir == '/'))
					{
						cssdir += "dir_selected";
						cssdir_onmouseover = cssdir+"i";
						cssdir_onmouseout  = cssdir;
					}
					else
					{
						if (i == 0 && this.current_dir != '/')
						{
							cssdir = "dir_up";
							dir = MSG(['box','savedir_parentdir']);
						}
						else
						{
							cssdir = "dir";
						}

						cssdir_onmouseover = cssdir+"i";
						cssdir_onmouseout  = cssdir;
					}

					// Liste Repertoires
					filebrowser += '<table id="'+this.self+'_dir'+i+'" class="'+cssdir+'" onmouseover="GIWIK.css.setClass(\''+this.self+'_dir'+i+'\',\''+cssdir_onmouseover+'\')" onmouseout="GIWIK.css.setClass(\''+this.self+'_dir'+i+'\',\''+cssdir_onmouseout+'\')"><tr>';

					// GO TO DIR: Tjrs présent
					filebrowser +=  '<td class="tdleft">'
									+ '<a href="javascript:'+this.self+'.gotodir(\''+dir_escaped+'\');">'+dir+'</a>'
								+ '</td>';

					// REMOVE:
					if (this.operating_mode == 'cgi')
					{
						// S'il ne s'agit pas du rep de plus haut niveau ET qu'il ne s'agit pas du repertoire selectionné
						if( i!=0  && dir_escaped != this.save_dir )
						{
							// Le repertoire ne contient pas le repertoire de log
							if( this.save_dir.indexOf(dir_escaped)<0 )
							{
								filebrowser += '<td class="tdright">'
												+ '<a href="javascript:'+this.self+'.removedir(\''+dir_escaped+'\');">'+MSG(['box','remove_dir'])+'</a>'
											+ '</td>';
							}
						}
					}

					// SELECTED: S'il s'agit du dossier sélectionné,
					if (dir_escaped == this.save_dir && ((this.current_dir != '/' && i != 0) || this.current_dir == '/'))
					{
						filebrowser += '<td class="tdright"><span>'+MSG(['box','savedir_selected'])+'</span></td>';
					}
					// SELECT: S'il s'agit du poste de travail OU s'il ne s'agit pas du poste de travail ET qu'il ne s'agit pas du "folder up" on affiche le bouton de sélection du dossier
					else if ((this.current_dir != '/' && i != 0) || this.current_dir == '/')
					{
						// Select ssi pas de log en court
						if (this.log_inprogress == 0)
						{
							filebrowser += '<td class="tdright">'
										+ '<a href="javascript:'+this.self+'.setsavedir(\''+dir_escaped+'\')">'+MSG(['box','savedir_select'])+'</a>'
									+ '</td>';
						}
					}

					filebrowser += '</tr></table>';
				}

				// Si on se trouve dans un dossier sans enfants
				// --> Moche
				/*if (this._listdir.length == 1 && this.current_dir != '/')
				{
					filebrowser += '<div class="nochilddir">'+MSG(['box','savedir_childdir'])+'</div>';
				}*/



				if (this.operating_mode == 'cgi')
				{
					// Liste Fichiers
					// ------------------
					for (i=0; i<this._listfile.length; i++)
					{
						file = this._listfile[i];
						filesize = this._listfilesize[i];

						// Echappement des antislashes et des guillemets simples
						file_escaped = file.replace(/\\/g,"\\\\");
						file_escaped = file_escaped.replace(/'/g,"\\'");


						var cssfile = "file";
						var cssfile_onmouseover = "filei";
						var cssfile_onmouseout = "file";


						filebrowser += '<table id="'+this.self+'_file'+i+'" class="'+cssfile+'" onmouseover="GIWIK.css.setClass(\''+this.self+'_file'+i+'\',\''+cssfile_onmouseover+'\')" onmouseout="GIWIK.css.setClass(\''+this.self+'_file'+i+'\',\''+cssfile_onmouseout+'\')"><tr>'
									+ '<td class="tdleft">'
										+ '<dir id="'+this.self+'_tooltip"'+' title="'+filesize+'">'
											+ '<a href="'+this.base_directory+file_escaped+'">'+file+'</a>'
										+ '</div>'
									+ '</td>';


						// REMOVE: ssi pas de log en cours OU pas le rep de log
						if (this.log_inprogress==0 || this.current_dir!=this.save_dir)
						{
							filebrowser += '<td class="tdright">'
											 + '<a href="javascript:'+this.self+'.removefile(\''+file_escaped+'\');">'+MSG(['box','remove_file'])+'</a>'
										 + '</td>';
						}
						filebrowser += '</tr></table>';
					}


					// Champ de Creation repertoire
					// --------------------------------------
					filebrowser += '<table id='+this.self+'_create class="createfolder" onmouseover="GIWIK.css.setClass(\''+this.self+'_create\',\'createfolderi\')" onmouseout="GIWIK.css.setClass(\''+this.self+'_create\',\'createfolder\')"><tr>'
								+ '<td class="tdleft"><a href="">&nbsp</a></td>'
								+ '<td><div id="'+this.self+'_create_folder"></div></td>'
								+ '<td class="tdright"><a href="javascript:'+this.self+'.createfolder();">'+MSG(['box','create_dir'])+'</a></td>'
							+ '</tr></table>';
				}

				//alert(filebrowser);

				// Read Current CreateFolder Input if defined (to keep it when updating)
				this.current_createfolder_input = "";

				if (typeof window[this.self+'_Create_Folder'] != 'undefined' && this.createfolder_done == 0)
				{
					this.current_createfolder_input = window[this.self+'_Create_Folder'].getValue();
				}

				// Init indicateur creation rep
				this.createfolder_done = 0;

				// Mise à Jour du FileBrowser
				GIWIK.write(this.filebrowser_content, filebrowser);
				GIWIK.write(this.savedirfield, this.save_dir);


				if (this.operating_mode == 'cgi')
				{
					if (!HEADING.init.isdone)
					{
						// CreateFolder Input
						window[this.self+'_Create_Folder'] = new Input_text(this.self+'_Create_Folder', false);
						window[this.self+'_Create_Folder'].label_width = 100;
						window[this.self+'_Create_Folder'].input_width = 150;
						window[this.self+'_Create_Folder'].margin = "2px 0px 2px 0px";
						window[this.self+'_Create_Folder'].text_align = "left";
						window[this.self+'_Create_Folder'].construct(this.self+'_create_folder','linear',MSG(['parameters','create_folder_label']),'',false);
						window[this.self+'_Create_Folder'].input_path.style.fontWeight = "normal";
						window[this.self+'_Create_Folder'].input_path.style.color = GIWIK.css.color_text_param;
						window[this.self+'_Create_Folder'].label_path.style.fontWeight = "normal";
						window[this.self+'_Create_Folder'].label_path.style.color = GIWIK.css.color_text_param;
						window[this.self+'_Create_Folder'].enable();
						window[this.self+'_Create_Folder'].show();
					}

					window[this.self+'_Create_Folder'].setValue(this.current_createfolder_input);
				}

			}
			else
			{
				setTimeout(this.self+".updatefilebrowser();", 20);
			}
		}
	};

	// A MODIFIER : PAS DE LIEN EN DUR TMPFAP
	this.set_statusmsg = function (code)
	{
		if (MSG.loggingstatuscode[code])
		{
			// application d'une bordure au message dans le cas de warning ou alert
			window.Usermsg_logging.setStatus(MSG.defineState(code), (code < 1001) ? false : true);

			// application du message en reprenant le message d'infos secondaires
			window.Usermsg_logging.setValue(MSG(['loggingstatuscode',code]));

			// affichage du message
			window.Usermsg_logging.show();
		}
	};

	this.connected = function ()
	{
		window.Stop_logging.enable();
		this.set_statusmsg(1);
	};

	this.disconnected = function ()
	{
		window.Stop_logging.disable();
		this.set_statusmsg(2);
	};

	this.error = function (code)
	{
		window.Stop_logging.disable();
		this.set_statusmsg(code);
	};
};

